
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

float		g_splashShader_scroll;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 uv			: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR0;
	float2 uv			: TEXCOORD0;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT vs_water_wake_particle( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	output.position = mul(input.position, shader_transform_viewProj);
	output.colour = input.colour;
	output.uv = input.uv;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
};

///////////////////////////////////////////////////////////

float4 ps_water_wake_particle( VS_OUTPUT input ) : COLOR
{
	return float4(0,0,0,tex2D(sampler_colour_1,input.uv).a * input.colour.a);
}

////////////////////////////////////////////////////////////

technique water_wake_particle_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_water_wake_particle();	
		PixelShader = compile ps_2_0 ps_water_wake_particle();	
	}
}

////////////////////////////////////////////////////////////
